<?php
// ---------- Active helpers ----------
$uri   = strtok($_SERVER['REQUEST_URI'] ?? $_SERVER['PHP_SELF'] ?? '', '?');
$base  = basename($uri);
$path  = ltrim($uri, '/');

function is_active_link(string $href): bool {
  global $uri, $base, $path;
  $href = trim($href, '/');
  return $base === basename($href) || str_ends_with($path, $href) || str_contains($uri, "/$href");
}
if (!function_exists('str_ends_with')) {
  function str_ends_with($h,$n){$l=strlen($n);return $l===0||substr($h,-$l)===$n;}
}
if (!function_exists('str_contains')) {
  function str_contains($h,$n){return $n===''||strpos($h,$n)!==false;}
}
function group_has(array $hrefs): bool { foreach ($hrefs as $h) if (is_active_link($h)) return true; return false; }
function aclass(string $href): string { return is_active_link($href) ? ' active' : ''; }
function liclass(string $href): string { return is_active_link($href) ? ' active' : ''; }
function g_show(array $hrefs): string { return group_has($hrefs) ? ' show' : ''; }
function g_exp(array $hrefs): string { return group_has($hrefs) ? 'true' : 'false'; }

// ---------- Permission helpers ----------
if (!function_exists('can_any')) {
  function can_any(array $codes): bool {
    if (!function_exists('can')) return true; // if RBAC not loaded, show everything
    foreach ($codes as $c) { if (can($c)) return true; }
    return false;
  }
}

// ---------- Groups (for "open" highlight) ----------
$g_staff     = ['pages/staff/allstaff.php','pages/staff/newstaff.php'];
$g_lend      = ['pages/lend/alllenddetails.php','pages/lend/ezycashdetails.php','pages/lend/instantdetails.php','pages/lend/rejectedlends.php'];
$g_approved  = ['pages/approvedloans/approved_lends.php','pages/approvedloans/approved_ezy_lends.php','pages/approvedloans/approved_instant_lends.php'];
$g_clients   = ['pages/clients/allclients.php'];
$g_broadcast = ['pages/broadcast/Notifications.php','pages/broadcast/Pop-up_Card.php','pages/broadcast/Banners.php','pages/broadcast/Status.php','pages/broadcast/SMS.php','pages/broadcast/E-Mail.php'];
$g_extras    = ['pages/extras/charges.php'];
$g_reports   = ['pages/reports/Lend_Details_Report.php','pages/reports/Login_Report.php','pages/reports/Users_Report.php','pages/reports/Clients_Report.php'];
$g_more      = ['pages/more/notification_sounds_admin.php','pages/more/opening_screen.php','pages/more/logo.php','pages/more/splash_screen.php','pages/more/icons.php','pages/more/social_media.php','pages/more/animations_screens.php','pages/more/app_icon.php'];
$g_settings  = ['pages/settings/access_control.php'];

// ---------- Visibility (map to your permission codes) ----------
$show_dashboard = can_any(['page:dashboard:view']);

$show_staff     = can_any(['page:staff:view','staff:view','staff:create']);
$show_staff_dir = can_any(['page:staff:view','staff:view']);
$show_staff_add = can_any(['staff:create','page:staff:add']);

$show_lend      = can_any(['page:lend:view','lend:records:view','lend:ezy:view','lend:instant:view','lend:rejected:view']);
$show_lend_all  = can_any(['lend:records:view','page:lend:view']);
$show_lend_ezy  = can_any(['lend:ezy:view']);
$show_lend_inst = can_any(['lend:instant:view']);
$show_lend_rej  = can_any(['lend:rejected:view']);

$show_approved  = can_any(['page:approved:view','approved:view']);
$show_approved_all = can_any(['approved:view','approved:all:view']);
$show_approved_ezy = can_any(['approved:ezy:view']);
$show_approved_inst= can_any(['approved:instant:view']);

$show_clients   = can_any(['page:clients:view','clients:view']);

$show_broadcast = can_any(['page:broadcast:view','broadcast:view']);
$show_b_notif   = can_any(['broadcast:notifications:view']);
$show_b_popup   = can_any(['broadcast:popup:view']);
$show_b_banners = can_any(['broadcast:banners:view']);
$show_b_status  = can_any(['broadcast:status:view']);
$show_b_sms     = can_any(['broadcast:sms:view']);
$show_b_email   = can_any(['broadcast:email:view']);

$show_extras    = can_any(['page:extras:view','charges:update']);
$show_charges   = can_any(['charges:update','charges:view']);

$show_reports   = can_any(['page:reports:view','reports:view']);
$show_r_lends   = can_any(['reports:lends:view']);
$show_r_login   = can_any(['reports:logins:view']);
$show_r_users   = can_any(['reports:users:view']);
$show_r_clients = can_any(['reports:clients:view']);

$show_more      = can_any(['page:more:view','more:view']);
$show_more_sounds   = can_any(['settings:sounds:update','settings:view']);
$show_more_opening  = can_any(['settings:opening:update','settings:view']);
$show_more_logo     = can_any(['settings:logo:update','settings:view']);
$show_more_splash   = can_any(['settings:splash:update','settings:view']);
$show_more_icons    = can_any(['settings:icons:update','settings:view']);
$show_more_social   = can_any(['settings:social:update','settings:view']);
$show_more_anim     = can_any(['settings:animations:update','settings:view']);
$show_more_appicon  = can_any(['settings:appicon:update','settings:view']);

$show_settings  = can_any(['page:settings:view','settings:update']);
$show_accessctl = can_any(['settings:update','page:settings:view']); // view shows page; update enables editing
?>
<style>
/* highlight selected sub items */
.sidebar .nav .sub-menu .nav-link.active,
.sidebar .nav .sub-menu .nav-item.active > .nav-link{
  background: rgba(255,255,255,.16);
  color:#fff !important;
  border-radius:4px;
  font-weight:600;
}
</style>

<!-- sidebar-->
<nav class="sidebar sidebar-offcanvas" id="sidebar">
  <ul class="nav">

    <?php if ($show_dashboard): ?>
    <li class="nav-item<?= liclass('index.php') ?>">
      <a class="nav-link<?= aclass('index.php') ?>" href="index.php">
        <i class="icon-grid menu-icon mdi mdi-view-dashboard-outline"></i>
        <span class="menu-title">Dashboard</span>
      </a>
    </li>
    <?php endif; ?>

    <?php if ($show_staff): ?>
    <li class="nav-item<?= group_has($g_staff)?' active':'' ?>">
      <a class="nav-link" data-toggle="collapse" href="#staff" aria-expanded="<?= g_exp($g_staff) ?>" aria-controls="staff">
        <i class="icon-layout menu-icon mdi mdi-account-group-outline"></i>
        <span class="menu-title">Staff</span>
        <i class="menu-arrow"></i>
      </a>
      <div class="collapse<?= g_show($g_staff) ?>" id="staff">
        <ul class="nav flex-column sub-menu">
          <?php if ($show_staff_dir): ?>
          <li class="nav-item<?= liclass('pages/staff/allstaff.php') ?>">
            <a class="nav-link<?= aclass('pages/staff/allstaff.php') ?>" href="pages/staff/allstaff.php">Staff Directory</a>
          </li>
          <?php endif; ?>
          <?php if ($show_staff_add): ?>
          <li class="nav-item<?= liclass('pages/staff/newstaff.php') ?>">
            <a class="nav-link<?= aclass('pages/staff/newstaff.php') ?>" href="pages/staff/newstaff.php">Add Staff</a>
          </li>
          <?php endif; ?>
        </ul>
      </div>
    </li>
    <?php endif; ?>

    <?php if ($show_lend): ?>
    <li class="nav-item<?= group_has($g_lend)?' active':'' ?>">
      <a class="nav-link" data-toggle="collapse" href="#lend" aria-expanded="<?= g_exp($g_lend) ?>" aria-controls="lend">
        <i class="icon-columns menu-icon mdi mdi-cash-multiple"></i>
        <span class="menu-title">Lend</span>
        <i class="menu-arrow"></i>
      </a>
      <div class="collapse<?= g_show($g_lend) ?>" id="lend">
        <ul class="nav flex-column sub-menu">
          <?php if ($show_lend_all): ?>
          <li class="nav-item<?= liclass('pages/lend/alllenddetails.php') ?>">
            <a class="nav-link<?= aclass('pages/lend/alllenddetails.php') ?>" href="pages/lend/alllenddetails.php">Lend Records</a>
          </li>
          <?php endif; ?>
          <?php if ($show_lend_ezy): ?>
          <li class="nav-item<?= liclass('pages/lend/ezycashdetails.php') ?>">
            <a class="nav-link<?= aclass('pages/lend/ezycashdetails.php') ?>" href="pages/lend/ezycashdetails.php">EzyCash Lend Details</a>
          </li>
          <?php endif; ?>
          <?php if ($show_lend_inst): ?>
          <li class="nav-item<?= liclass('pages/lend/instantdetails.php') ?>">
            <a class="nav-link<?= aclass('pages/lend/instantdetails.php') ?>" href="pages/lend/instantdetails.php">Instant Lend Details</a>
          </li>
          <?php endif; ?>
          <?php if ($show_lend_rej): ?>
          <li class="nav-item<?= liclass('pages/lend/rejectedlends.php') ?>">
            <a class="nav-link<?= aclass('pages/lend/rejectedlends.php') ?>" href="pages/lend/rejectedlends.php">Rejected Lends</a>
          </li>
          <?php endif; ?>
        </ul>
      </div>
    </li>
    <?php endif; ?>

    <?php if ($show_approved): ?>
    <li class="nav-item<?= group_has($g_approved)?' active':'' ?>">
      <a class="nav-link" data-toggle="collapse" href="#approved_lends" aria-expanded="<?= g_exp($g_approved) ?>" aria-controls="approved_lends">
        <i class="icon-columns menu-icon mdi mdi-check-decagram-outline"></i>
        <span class="menu-title">Approved Loans</span>
        <i class="menu-arrow"></i>
      </a>
      <div class="collapse<?= g_show($g_approved) ?>" id="approved_lends">
        <ul class="nav flex-column sub-menu">
          <?php if ($show_approved_all): ?>
          <li class="nav-item<?= liclass('pages/approvedloans/approved_lends.php') ?>">
            <a class="nav-link<?= aclass('pages/approvedloans/approved_lends.php') ?>" href="pages/approvedloans/approved_lends.php">Approved Loans</a>
          </li>
          <?php endif; ?>
          <?php if ($show_approved_ezy): ?>
          <li class="nav-item<?= liclass('pages/approvedloans/approved_ezy_lends.php') ?>">
            <a class="nav-link<?= aclass('pages/approvedloans/approved_ezy_lends.php') ?>" href="pages/approvedloans/approved_ezy_lends.php">EzyCash Lends</a>
          </li>
          <?php endif; ?>
          <?php if ($show_approved_inst): ?>
          <li class="nav-item<?= liclass('pages/approvedloans/approved_instant_lends.php') ?>">
            <a class="nav-link<?= aclass('pages/approvedloans/approved_instant_lends.php') ?>" href="pages/approvedloans/approved_instant_lends.php">Instant Lends</a>
          </li>
          <?php endif; ?>
        </ul>
      </div>
    </li>
    <?php endif; ?>

    <?php if ($show_clients): ?>
    <li class="nav-item<?= group_has($g_clients)?' active':'' ?>">
      <a class="nav-link" data-toggle="collapse" href="#Clients" aria-expanded="<?= g_exp($g_clients) ?>" aria-controls="Clients">
        <i class="icon-user-group mdi mdi-account-outline"></i>
        <span class="menu-title">Clients</span>
        <i class="menu-arrow"></i>
      </a>
      <div class="collapse<?= g_show($g_clients) ?>" id="Clients">
        <ul class="nav flex-column sub-menu">
          <li class="nav-item<?= liclass('pages/clients/allclients.php') ?>">
            <a class="nav-link<?= aclass('pages/clients/allclients.php') ?>" href="pages/clients/allclients.php">All Clients</a>
          </li>
        </ul>
      </div>
    </li>
    <?php endif; ?>

    <?php if ($show_broadcast): ?>
    <li class="nav-item<?= group_has($g_broadcast)?' active':'' ?>">
      <a class="nav-link" data-toggle="collapse" href="#broadcast" aria-expanded="<?= g_exp($g_broadcast) ?>" aria-controls="broadcast">
        <i class="icon-user-group mdi mdi-bullhorn-outline"></i>
        <span class="menu-title">Broadcast</span>
        <i class="menu-arrow"></i>
      </a>
      <div class="collapse<?= g_show($g_broadcast) ?>" id="broadcast">
        <ul class="nav flex-column sub-menu">
          <?php if ($show_b_notif): ?>
          <li class="nav-item<?= liclass('pages/broadcast/Notifications.php') ?>">
            <a class="nav-link<?= aclass('pages/broadcast/Notifications.php') ?>" href="pages/broadcast/Notifications.php">Notifications</a>
          </li>
          <?php endif; ?>
          <?php if ($show_b_popup): ?>
          <li class="nav-item<?= liclass('pages/broadcast/Pop-up_Card.php') ?>">
            <a class="nav-link<?= aclass('pages/broadcast/Pop-up_Card.php') ?>" href="pages/broadcast/Pop-up_Card.php">Pop-up Card</a>
          </li>
          <?php endif; ?>
          <?php if ($show_b_banners): ?>
          <li class="nav-item<?= liclass('pages/broadcast/Banners.php') ?>">
            <a class="nav-link<?= aclass('pages/broadcast/Banners.php') ?>" href="pages/broadcast/Banners.php">Banners</a>
          </li>
          <?php endif; ?>
          <?php if ($show_b_status): ?>
          <li class="nav-item<?= liclass('pages/broadcast/Status.php') ?>">
            <a class="nav-link<?= aclass('pages/broadcast/Status.php') ?>" href="pages/broadcast/Status.php">Status</a>
          </li>
          <?php endif; ?>
          <?php if ($show_b_sms): ?>
          <li class="nav-item<?= liclass('pages/broadcast/SMS.php') ?>">
            <a class="nav-link<?= aclass('pages/broadcast/SMS.php') ?>" href="pages/broadcast/SMS.php">SMS</a>
          </li>
          <?php endif; ?>
          <?php if ($show_b_email): ?>
          <li class="nav-item<?= liclass('pages/broadcast/E-Mail.php') ?>">
            <a class="nav-link<?= aclass('pages/broadcast/E-Mail.php') ?>" href="pages/broadcast/E-Mail.php">E-Mail</a>
          </li>
          <?php endif; ?>
        </ul>
      </div>
    </li>
    <?php endif; ?>

    <?php if ($show_extras): ?>
    <li class="nav-item<?= group_has($g_extras)?' active':'' ?>">
      <a class="nav-link" data-toggle="collapse" href="#extras" aria-expanded="<?= g_exp($g_extras) ?>" aria-controls="extras">
        <i class="icon-bar-graph menu-icon mdi mdi-tune-variant"></i>
        <span class="menu-title">Extras</span>
        <i class="menu-arrow"></i>
      </a>
      <div class="collapse<?= g_show($g_extras) ?>" id="extras">
        <ul class="nav flex-column sub-menu">
          <?php if ($show_charges): ?>
          <li class="nav-item<?= liclass('pages/extras/charges.php') ?>">
            <a class="nav-link<?= aclass('pages/extras/charges.php') ?>" href="pages/extras/charges.php">Revise Charges</a>
          </li>
          <?php endif; ?>
        </ul>
      </div>
    </li>
    <?php endif; ?>

    <?php if ($show_reports): ?>
    <li class="nav-item<?= group_has($g_reports)?' active':'' ?>">
      <a class="nav-link" data-toggle="collapse" href="#Reports" aria-expanded="<?= g_exp($g_reports) ?>" aria-controls="Reports">
        <i class="icon-grid-2 menu-icon mdi mdi-file-chart-outline"></i>
        <span class="menu-title">Reports</span>
        <i class="menu-arrow"></i>
      </a>
      <div class="collapse<?= g_show($g_reports) ?>" id="Reports">
        <ul class="nav flex-column sub-menu">
          <?php if ($show_r_lends): ?>
          <li class="nav-item<?= liclass('pages/reports/Lend_Details_Report.php') ?>">
            <a class="nav-link<?= aclass('pages/reports/Lend_Details_Report.php') ?>" href="pages/reports/Lend_Details_Report.php">Lend Details Report</a>
          </li>
          <?php endif; ?>
          <?php if ($show_r_login): ?>
          <li class="nav-item<?= liclass('pages/reports/Login_Report.php') ?>">
            <a class="nav-link<?= aclass('pages/reports/Login_Report.php') ?>" href="pages/reports/Login_Report.php">Login Report</a>
          </li>
          <?php endif; ?>
          <?php if ($show_r_users): ?>
          <li class="nav-item<?= liclass('pages/reports/Users_Report.php') ?>">
            <a class="nav-link<?= aclass('pages/reports/Users_Report.php') ?>" href="pages/reports/Users_Report.php">Users Report</a>
          </li>
          <?php endif; ?>
          <?php if ($show_r_clients): ?>
          <li class="nav-item<?= liclass('pages/reports/Clients_Report.php') ?>">
            <a class="nav-link<?= aclass('pages/reports/Clients_Report.php') ?>" href="pages/reports/Clients_Report.php">Clients Report</a>
          </li>
          <?php endif; ?>
        </ul>
      </div>
    </li>
    <?php endif; ?>

    <?php if ($show_more): ?>
    <li class="nav-item<?= group_has($g_more)?' active':'' ?>">
      <a class="nav-link" data-toggle="collapse" href="#more" aria-expanded="<?= g_exp($g_more) ?>" aria-controls="more">
        <i class="icon-bar-graph menu-icon mdi mdi-cog-outline"></i>
        <span class="menu-title">More</span>
        <i class="menu-arrow"></i>
      </a>
      <div class="collapse<?= g_show($g_more) ?>" id="more">
        <ul class="nav flex-column sub-menu">
          <?php if ($show_more_sounds): ?>
          <li class="nav-item<?= liclass('pages/more/notification_sounds_admin.php') ?>">
            <a class="nav-link<?= aclass('pages/more/notification_sounds_admin.php') ?>" href="pages/more/notification_sounds_admin.php">Sounds</a>
          </li>
          <?php endif; ?>
          <?php if ($show_more_opening): ?>
          <li class="nav-item<?= liclass('pages/more/opening_screen.php') ?>">
            <a class="nav-link<?= aclass('pages/more/opening_screen.php') ?>" href="pages/more/opening_screen.php">Opening Screen</a>
          </li>
          <?php endif; ?>
          <?php if ($show_more_logo): ?>
          <li class="nav-item<?= liclass('pages/more/logo.php') ?>">
            <a class="nav-link<?= aclass('pages/more/logo.php') ?>" href="pages/more/logo.php">Logo</a>
          </li>
          <?php endif; ?>
          <?php if ($show_more_splash): ?>
          <li class="nav-item<?= liclass('pages/more/splash_screen.php') ?>">
            <a class="nav-link<?= aclass('pages/more/splash_screen.php') ?>" href="pages/more/splash_screen.php">Splash Screen</a>
          </li>
          <?php endif; ?>
          <?php if ($show_more_icons): ?>
          <li class="nav-item<?= liclass('pages/more/icons.php') ?>">
            <a class="nav-link<?= aclass('pages/more/icons.php') ?>" href="pages/more/icons.php">Icons</a>
          </li>
          <?php endif; ?>
          <?php if ($show_more_social): ?>
          <li class="nav-item<?= liclass('pages/more/social_media.php') ?>">
            <a class="nav-link<?= aclass('pages/more/social_media.php') ?>" href="pages/more/social_media.php">Social Media</a>
          </li>
          <?php endif; ?>
          <?php if ($show_more_anim): ?>
          <li class="nav-item<?= liclass('pages/more/animations_screens.php') ?>">
            <a class="nav-link<?= aclass('pages/more/animations_screens.php') ?>" href="pages/more/animations_screens.php">Animations Screens</a>
          </li>
          <?php endif; ?>
          <?php if ($show_more_appicon): ?>
          <li class="nav-item<?= liclass('pages/more/app_icon.php') ?>">
            <a class="nav-link<?= aclass('pages/more/app_icon.php') ?>" href="pages/more/app_icon.php">App Icon</a>
          </li>
          <?php endif; ?>
        </ul>
      </div>
    </li>
    <?php endif; ?>

    <?php if ($show_settings): ?>
    <li class="nav-item<?= group_has($g_settings)?' active':'' ?>">
      <a class="nav-link" data-toggle="collapse" href="#settings" aria-expanded="<?= g_exp($g_settings) ?>" aria-controls="settings">
        <i class="icon-bar-settings menu-icon mdi mdi-shield-key-outline"></i>
        <span class="menu-title">Settings</span>
        <i class="menu-arrow"></i>
      </a>
      <div class="collapse<?= g_show($g_settings) ?>" id="settings">
        <ul class="nav flex-column sub-menu">
          <?php if ($show_accessctl): ?>
          <li class="nav-item<?= liclass('pages/settings/access_control.php') ?>">
            <a class="nav-link<?= aclass('pages/settings/access_control.php') ?>" href="pages/settings/access_control.php">Access Control</a>
          </li>
          <?php endif; ?>
        </ul>
      </div>
    </li>
    <?php endif; ?>

  </ul>
</nav>
<!-- sidebar-->
